#!/usr/bin/env python3

import socket
import json

ZONES = {
    "example.com": {
        "A": "127.0.0.1",
        "AAAA": "::1"
    },
    "aamot.io": {
        "A": "185.199.108.153",
        "AAAA": "2606:50c0:8000::153"
    }
}

HOST = "127.0.0.1"
PORT = 5453

server = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
server.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
server.bind((HOST, PORT))
server.listen(50)

while True:
    conn, addr = server.accept()
    print(f"Server is listening on {HOST}:{PORT}")
    try:
        req = conn.recv(1024).decode()
        data = json.loads(req)
        with conn:
            print(f"Connected by {addr}")
            while True:
                data = json.loads(req)
                if not data:
                    break
                data = data.decode()
                if data.startswith("{") and data.endswith("}"):
                    response = handle_dns_update(data)
                else:
                    response = handle_dns_lookup(data)
                    conn.sendall(response.encode())
                    
                    name = data["name"]
                    qtype = data["type"]
                    
                    ip = ZONES.get(name, {}).get(qtype)
                    
                    if ip:
                        resp = {"status": "ok", "ip": ip}
                    else:
                        resp = {"status": "notfound"}
                        
                        conn.send((json.dumps(resp)+"\n").encode())
                        
                        name = data["name"]
                        qtype = data["type"]
                        
                        ip = ZONES.get(name, {}).get(qtype)
                        
                        if ip:
                            resp = {"status": "ok", "ip": ip}
                        else:
                            resp = {"status": "notfound"}
                            
                            conn.send((json.dumps(resp)+"\n").encode())
                            
    except:
        pass
    
    conn.close()
    
