#!/usr/bin/env python3

import socket
import json

ZONES = {
    "example.com": {
        "A": "127.0.0.1",
        "AAAA": "::1"
    },
    "aamot.io": {
        "A": "185.199.108.153",
        "AAAA": "2606:50c0:8000::153"
    }
}

HOST = "127.0.0.1"
PORT = 5453

server = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
server.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
server.bind((HOST, PORT))
server.listen(50)

# Function to handle DNS lookup requests
def handle_dns_lookup(data):
    domain = data.strip()
    if domain in dns_records:
        response_data = {
            "domain_name": domain,
            "dns_records": dns_records[domain]
        }
        return json.dumps(response_data)
    else:
        return json.dumps({"error": "Domain not found"})

# Function to handle DNS update requests
def handle_dns_update(data):

    server = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    server.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    server.bind((HOST, PORT))
    server.listen(50)
    
    while True:
        conn, addr = server.accept()
        print(f"Server is listening on {HOST}:{PORT}")
        try:
            data = json.loads(data)
            if data["action"] == "update":
                domain = data["domain"]
                record_type = data["type"]
                record_data = data["data"]
                if domain in dns_records:
                    if record_type in dns_records[domain]:
                        dns_records[domain][record_type].append(record_data)
                        req = conn.recv(1024).decode()
                        data = json.loads(req)
                        with conn:
                            print(f"Connected by {addr}")
                            while True:
                                data = json.loads(req)
                                if not data:
                                    break
                                data = data.decode()
                                if data.startswith("{") and data.endswith("}"):
                                    response = handle_dns_update(data)
                                else:
                                    dns_records[domain] = {record_type: [record_data]}
                                    return json.dumps({"status": "success", "message": "DNS record updated successfully"})
                            else:
                                return json.dumps({"status": "error", "message": "Invalid action"})
        except Exception as e:
            return json.dumps({"status": "error", "message": f"Error: {e}"})

# Main server function
def run_server():
    with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as server_socket:
        server_socket.bind((HOST, PORT))
        server_socket.listen()
        
        print(f"Server is listening on {HOST}:{PORT}")
        
        while True:
            conn, addr = server_socket.accept()
            with conn:
                print(f"Connected by {addr}")
                while True:
                    data = conn.recv(1024)
                    if not data:
                        break
                    data = data.decode()
                    if data.startswith("{") and data.endswith("}"):
                        response = handle_dns_update(data)
                    else:
                        response = handle_dns_lookup(data)
                    
                    response = handle_dns_lookup(data)
                    conn.sendall(response.encode())
                    name = data["name"]
                    qtype = data["type"]
                    
                    ip = ZONES.get(name, {}).get(qtype)
                    
                    if ip:
                        resp = {"status": "ok", "ip": ip}
                    else:
                        resp = {"status": "notfound"}
                        
                        conn.send((json.dumps(resp)+"\n").encode())

                    if __name__ == "__main__":
                        run_server()
                        
                        name = data["name"]
                        qtype = data["type"]
                        
                        ip = ZONES.get(name, {}).get(qtype)
                        
                        if ip:
                            resp = {"status": "ok", "ip": ip}
                        else:
                            resp = {"status": "notfound"}
                        
                            conn.send((json.dumps(resp)+"\n").encode())
                            
                            name = data["name"]
                            qtype = data["type"]
                            
                            ip = ZONES.get(name, {}).get(qtype)
                            
                            if ip:
                                resp = {"status": "ok", "ip": ip}
                            else:
                                resp = {"status": "notfound"}
                                conn.send((json.dumps(resp)+"\n").encode())
                            conn.close()
