#!/usr/bin/python3
#
# $id$
#
# wikidns-client.py
#
# Copyright (C) 2024  Aamot Engineering <ole@aamot.engineering>
# Copyright (C) 2024  Ole Aamot <ole@gnu.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import socket
import json

# Server configuration
SERVER_HOST = '178.255.144.178'
SERVER_PORT = 5453 

# Function to send DNS lookup requests
def dns_lookup(domain):
    with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as client_socket:
        client_socket.connect((SERVER_HOST, SERVER_PORT))
        client_socket.sendall(domain.encode())
        response = client_socket.recv(1024)
        return response.decode()

# Function to send DNS update requests
def update_dns_record(domain, record_type, record_data):
    with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as client_socket:
        client_socket.connect((SERVER_HOST, SERVER_PORT))
        request_data = {
            "action": "update",
            "domain": domain,
            "type": record_type,
            "data": record_data
        }
        client_socket.sendall(json.dumps(request_data).encode())
        response = client_socket.recv(1024)
        return response.decode()

# Main client function
def run_client():
    while True:
        print("\n1. DNS Lookup")
        print("2. Update DNS Record")
        print("3. Quit")
        choice = input("Enter your choice: ")

        if choice == '1':
            domain = input("Enter domain name: ")
            result = dns_lookup(domain)
            print(f"DNS lookup result for {domain}:\n{result}")
        elif choice == '2':
            domain = input("Enter domain name: ")
            record_type = input("Enter record type (A/AAAA/MX/NS/SOA/SRV/TXT/CNAME): ")
            record_data = input("Enter record data: ")
            result = update_dns_record(domain, record_type, record_data)
            print(f"Response from server: {result}")
        elif choice == '3':
            break
        else:
            print("Invalid choice")

if __name__ == "__main__":
    run_client()

