#!/usr/bin/python3
#
# $id$
#
# wikidns-domain.py
#
# Copyright (C) 2024  Aamot Engineering <ole@aamot.engineering>
# Copyright (C) 2024  Ole Aamot <ole@gnu.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import dns.resolver

def resolve_dns_internet(domain, record_type='A'):
    """
    Resolves a DNS query for the given domain using an internet-based DNS resolver.
    """
    try:
        resolver = dns.resolver.Resolver()
        resolver.nameservers = ['8.8.8.8', '1.1.1.1']  # Public DNS servers
        answer = resolver.resolve(domain, record_type)
        print(f"DNS Records for {domain} ({record_type}):")
        for item in answer:
            print(item.to_text())
    except dns.resolver.NoAnswer:
        print(f"No answer for {domain} with record type {record_type}")
    except dns.resolver.NXDOMAIN:
        print(f"Domain {domain} does not exist.")
    except Exception as e:
        print(f"Error: {e}")

def main():
    domain = input("Enter the domain to resolve: ")
    record_type = input("Enter record type (A/MX/TXT): ") or 'A'
    resolve_dns_internet(domain, record_type)

if __name__ == "__main__":
    main()
