#!/usr/bin/python3
#
# $id$
#
# wikidns-rollon.py
#
# Copyright (C) 2024  Aamot Engineering <ole@aamot.engineering>
# Copyright (C) 2024  Ole Aamot <ole@gnu.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import socket

# Define DNS server settings
HOST = '127.0.0.1'
PORT = 53  # Standard DNS port

def parse_dns_message(data):
    """
    Parse DNS message and extract relevant information.
    For simplicity, this function just prints the received data.
    """
    print("Received DNS message:")
    print(data.hex())  # Print hexadecimal representation of the data

def main():
    # Create a UDP socket
    with socket.socket(socket.AF_INET, socket.SOCK_DGRAM) as server_socket:
        # Bind the socket to the host and port
        server_socket.bind((HOST, PORT))
        print(f"DNS server listening on {HOST}:{PORT}...")

        while True:
            # Receive data from client
            data, address = server_socket.recvfrom(1024)
            print(f"Received {len(data)} bytes from {address}")

            # Parse and process the received DNS message
            parse_dns_message(data)

if __name__ == "__main__":
    main()

